---
title: "Finding miRNA targets with mirDB and mirtarbase"
author: "A. hEMEDAN"

---

# Install
if(!require(devtools)) install.packages("devtools")
devtools::install_github("kassambara/miRTarget")

library(miRTarget)

# Get predicted miRNA targets
p_targets <- get_mirecords_pt(miRNAs, n = 5, species = "Homo sapiens",
                              result_file = "mirna_mirecords_predicted_targets.txt",
                              show_progress = FALSE)
## show results
head(p_targets, 10)

# get miRNA validated targets
## miRecords and miRtarbase are used.
mirecords_vt <- get_mirecords_vt(miRNAs,species = "Homo sapiens", version = 4)
mirtarbase_vt <- get_mirtarbase_vt(miRNAs)

# combine validated targets
v_targets <- combine_mir_vt(mirecords_vt, mirtarbase_vt)

# merge predicted and validated targets
targets <- combine_mir_pvt(p_targets, v_targets)

#If a gene is targeted by a miRNA we expect that the expression profile of the gene and the miRNA are anti-correlated
res.cor <- corr_mir_mrna( mir_targets = MirTarget(targets),
                          mir_mrna_exprs = mir_mrna_exprs, 
                          show_progress = FALSE, stand = TRUE)

## Number of mRNAs per miRNAs with an absolute correlation of 0.6
viz_mrna_per_mir(res.cor, coeff = 0.6)
## visualize the fraction of negative correlation
viz_neg_cor_fraction(res.cor)
## keep only negative correlation
## Negative correlation
neg.cor <- subset(res.cor, abs(cor.coeff) > 0.6 & cor.coeff < 0)
head(neg.cor, 10)
nmir <- length(unique(neg.cor$mirna_name))
ngn <- length(unique(neg.cor$target.gene_name))
valid <- subset(neg.cor, status %in% c("PV", "V"))